package gov.va.med.mhv.usermgmt.web.converter;

import java.io.Serializable;
import java.util.ArrayList;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.usermgmt.common.dto.HealthInfoDTO;
import gov.va.med.mhv.usermgmt.web.formbean.HealthInfoCard;

@Component
public class HealthInfoCardConverter implements Converter<HealthInfoDTO, HealthInfoCard>, Serializable {
    private static final long serialVersionUID = 1L;
    
	@Override
	public HealthInfoCard convert(HealthInfoDTO dto) {
		HealthInfoCard m = new HealthInfoCard();		
		
		m.setName(dto.getName());
		m.setMhvId(dto.getMhvId());
		m.setCountry(dto.getCountry());
		m.setAddr1(dto.getAddr1());
		m.setAddr2(dto.getAddr2());
		m.setCity(dto.getCity());
		m.setState(dto.getState());
		m.setZip(dto.getZip());
		m.setProvince(dto.getProvince());

		m.setHomePhone(dto.getHomePhone());
		m.setWorkPhone(dto.getWorkPhone());
		m.setMobilePhone(dto.getMobilePhone());
		
		m.setBloodType(dto.getBloodType());
		m.setEmail(dto.getEmail());
		
		m.setAllergies(new ArrayList<String>(dto.getAllergies()));
		
		m.setPrimaryProvider(dto.getPrimaryProvider());		
		m.setPrimaryProviderPhone(dto.getPrimaryProviderPhone()); 
	    m.setPrimaryProviderPhoneExtension(dto.getPrimaryProviderPhoneExtension());
		
		m.setPrimaryInsurance(dto.getPrimaryInsurance());
		m.setPrimaryInsuranceId(dto.getPrimaryInsuranceId());
		m.setPrimaryInsuranceGroupNumber(dto.getPrimaryInsuranceGroupNumber());
		m.setPrimaryInsurancePhone(dto.getPrimaryInsurancePhone());
		
		m.setEmergencyContactName(dto.getEmergencyContactName());
		m.setEmergencyContactEmail(dto.getEmergencyContactEmail());
		m.setEmergencyContactHomePhone(dto.getEmergencyContactHomePhone());
		m.setEmergencyContactWorkPhone(dto.getEmergencyContactWorkPhone());
		m.setEmergencyContactWorkPhoneExtension(dto.getEmergencyContactWorkPhoneExtension());
		m.setEmergencyContactMobilePhone(dto.getEmergencyContactMobilePhone());

		return m;
	}

}
